#version 430

layout(binding=0) uniform sampler2D texScreen;
layout(binding=1) uniform sampler2D texOverlay;

layout(binding=2) uniform sampler2D texScreen2;

in vec2 uv;

layout(location = 0) out vec4 frag;
layout(location = 1) out vec4 frag2;

uniform float g_time;
/*
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec3 tonemapUC2(vec3 x) {
    float A = 0.15;
    float B = 0.50;
    float C = 0.10;
    float D = 0.20;
    float E = 0.02;
    float F = 0.30;
    return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}
*/

//vec3 trianglet[][] =
//{
//    { vec3(0.0, 0.0, 0.0), vec3(1.0, 0.0, 0.0), vec3(0.0, 1.0, 0.0) },
//    { vec3(0.0, 0.0, 0.0), vec3(1.0, 0.0, 0.0), vec3(0.0, 1.0, 0.0) }
//};

//int numVerts = 30;
//float verts[] = { -0.5, -0.5 ,0.5,-0.5,-0.5,-0.5,-0.5,0,-0.5,-0.5,0,0.5,0,0.5,-0.5,0,0.5,0.5,0.5,-0.5,0.5,0.5,-0.5,-0.5,0.5,0.5,-0.5,0.5,0.5,0.5 };

//// faces size is numFaces*3 for triangles
//int numFaces = 16;
//int faces[] = { 4,2,-4,5,4,-4,8,9,-7,7,8,-7,9,5,-7,5,3,-7,3,0,-7,9,8,-6,8,4,-6,4,8,-8,2,4,-8,1,2,-8,7,6,-1,1,7,-1,2,1,-1,3,2,-1 };




uniform float flip=1.0;

uniform float overlayAlpha=1.0;

uniform float g_bgAmount = 1.0;
uniform float g_lightAmount = 1.0;
uniform float g_waterClip = 0.0;
uniform float g_bumpStrength = 1.0;

uniform float g_posX = 0.0;
uniform float g_posY = 0.0;

uniform float g_overlayScale = 1.0;

uniform float g_windowWidth = 1280.0;
uniform float g_windowHeight = 720.0;


// from Iq: http://www.iquilezles.org/www/articles/texture/texture.htm
vec4 getTexel( sampler2D s, vec2 p ) {
    //return texture2D(s, p);

    highp vec2 texRes = vec2(g_windowWidth, g_windowHeight);
    p = p*texRes+0.5;

    highp vec2 i = floor(p);
    highp vec2 f = p - i;
    f = f*f*f*(f*(f*6.0-15.0)+10.0);
    p = i + f;

    p = (p - 0.5)/texRes;
    return texture2D(s, p);
}

vec3 spreadSpec3(vec3 c, float sp) {
    sp = fract(sp);
    c.r *= smoothstep(1.0, 0.0, (1.0-sp)*1.0);
    c.g *= smoothstep(1.0, 0.0, abs((sp-0.5)*2.0));
    c.b *= smoothstep(1.0, 0.0, sp*1.0);
    return c;
}

vec4 spreadSpec(vec4 c, float sp) {
    sp = fract(sp);
    c.r *= smoothstep(1.0, 0.0, (1.0-sp)*1.0);
    c.g *= smoothstep(1.0, 0.0, abs((sp-0.5)*2.0));
    c.b *= smoothstep(1.0, 0.0, sp*1.0);
    return c;
}
float potSphere(vec3 pos, vec3 cen, float rad) {
    pos-=cen;
    float res = rad-sqrt(dot(pos, pos));
    return res;
}

// from http://iquilezles.org/www/articles/distfunctions/distfunctions.htm
// big thanks IQ!!
float udBox(vec3 p, vec3 b) {
  return length(max(abs(p)-b,0.0));
}

float potential(vec3 pos, float time) {
        return 0.5+0.5*0.333*(sin(pos.x*0.6+time*2.0+cos(pos.y*0.1))+
                              cos(pos.y*1.5+time*3.0+sin(pos.x*0.1))+
                              cos(pos.z*1.1+sin(pos.x*0.2)+time*1.5));
}

uniform float surfGridRes2D;

// 3D grid size which is the same for width, height & depth
uniform float surfGridDim3D;

// 1.0 scale puts the surfGrid to xyz coords varying from
// -surfGridDim3D*0.5 to surfGridDim3D*0.5
uniform float surfGridScale = 1.0;

// ivec2 ts = textureSize(s, 0);
// return texelFetch(s, ivec2(c.x*ts.x, c.y*ts.y), 0);


// gl_FragCoord.x

void main() {
    vec2 uvS = uv;
    //  uvS.y = 1.0-uvS.y;
    //  vec4 bg = texture2D(texOverlay, uvS);
    vec4 result = vec4(0.0);

    vec2 tp = vec2(gl_FragCoord.xy);
    float kb = surfGridRes2D/surfGridDim3D; // 10 for example when dim3d is 100 and res2d is 1000

    vec3 posCen3D = vec3(surfGridDim3D*0.5);
    vec3 pos3D = vec3(0.0);

    vec2 osa = tp/surfGridDim3D;
    vec2 cellXY = fract(osa)*surfGridDim3D;
    vec2 cellZ = floor(osa);
    float indZ = cellZ.x+cellZ.y*kb;

    pos3D = vec3(cellXY, indZ);

    float pot = potential(pos3D*0.150, g_time)*1.0;
  //  pot += potSphere(pos3D-posCen3D, vec3(0.0), 20.0)*0.10;
    pot *= udBox(pos3D-posCen3D, vec3(20.0));
    pot -= 0.5;

  //  pot = cellXY.x+cellXY.y;

    result.rgb = vec3(pot, pot, pot);
    result.a = 1.0;

    frag = result;
    frag2 = vec4(0.0, 0.0, 0.0, 0.0);
}
